/**
* \file: TouchListener.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_TOUCHLISTENER_H
#define AAUTO_TOUCHLISTENER_H

#include <time.h>
#include "WaylandContext.h"
#include "InputSourceReport.h"

namespace adit { namespace aauto
{

class TouchListener : public WaylandContext::DeviceListener
{
public:
    static struct wl_touch_listener Listener;

    TouchListener(InputReport& inInputReport, int inWidth, int inHeight, bool inVerbose, WaylandDeviceType inDeviceType);
    virtual ~TouchListener();

private:
    float x;
    float y;
    float width;
    float height;
    bool verbose;
    WaylandDeviceType wlDeviceType; // Type of touch device

    InputReport& report;

    /* Wayland touch listeners */
    static void handleDown(void* inData, struct wl_touch* inTouch, uint32_t inSerial,
            uint32_t inTime, struct wl_surface* inSurface, int32_t inID, wl_fixed_t inX,
            wl_fixed_t inY);
    static void handleUp(void* inData, struct wl_touch* inTouch,
            uint32_t inSerial, uint32_t inTime, int32_t inID);
    static void handleMotion(void* inData, struct wl_touch* inTouch,
            uint32_t inTime, int32_t inID, wl_fixed_t inX, wl_fixed_t inY);
    static void handleFrame(void* inData, struct wl_touch* inTouch);
    static void handleCancel(void* inData, struct wl_touch* inTouch);
};

} } /* namespace adit { namespace aauto */

#endif /* AAUTO_TOUCHLISTENER_H */
